/****************************************************************************************
**
** SPDX-FileCopyrightText: 2014 Jolla Ltd.
** SPDX-FileCopyrightText: 2023-2024 Open Mobile Platform LLC <community@omp.ru>
**
** SPDX-License-Identifier: BSD 3-Clause
**
****************************************************************************************/

import QtQuick 2.0
import Sailfish.Silica 1.0
import Sailfish.Silica.private 1.0

QuickScrollButtonBase {
    id: button

    property bool active
    property bool invert: direction === QuickScrollDirection.Down
    property alias source: image.source
    property int direction: QuickScrollDirection.Up
    property int directionsEnabled: QuickScrollDirection.UpAndDown
    readonly property bool _atBound: (direction == QuickScrollDirection.Up && flickable.atYBeginning)
                                     || (direction == QuickScrollDirection.Down && flickable.atYEnd)
    readonly property bool _display: (directionsEnabled & direction) && active

    on_DisplayChanged: {
        if (_display) {
            opacityAnimation.duration = 300
            opacity = 1.0
        } else {
            opacityAnimation.duration = 200
            opacity = 0.0
        }
    }

    width: Theme.itemSizeExtraLarge
    height: Theme.itemSizeExtraSmall + Theme.paddingMedium + Theme.iconSizeSmall
    enabled: _display && !_atBound
    opacity: 0.0

    Behavior on opacity {
        FadeAnimation {
            id: opacityAnimation

            easing.type: Easing.InOutCubic
        }
    }

    Rectangle {
        id: circle

        anchors.horizontalCenter: parent.horizontalCenter

        y: invert ? Theme.paddingMedium : Theme.iconSizeSmall
        width: Theme.itemSizeExtraSmall
        height: width
        radius: width * 0.5
        color: button.pressed ? Qt.tint(Theme.highlightColor, Theme.rgba(Theme.highlightBackgroundColor, 0.5))
                              : Theme.highlightColor
        opacity: button._atBound ? 0.4 : 1.0
    }

    Icon {
        id: image

        anchors.centerIn: circle
        width: Theme.iconSizeSmallPlus
        height: width
        sourceSize.width: width

        color: Theme.colorScheme === Theme.LightOnDark ? "black" : "white"
    }
}
