/*
 * SPDX-FileCopyrightText: 2012-2015 Jolla Ltd
 * SPDX-FileCopyrightText: 2023-2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

import QtQuick 2.0
import Sailfish.Silica 1.0
import Sailfish.Accounts 1.0
import com.jolla.settings 1.0

SilicaListView {
    id: root

    //-------------- api

    property alias filterType: accountModel.filterType
    property alias filter: accountModel.filter
    property bool entriesInteractive
    property bool _settingsApplicationStyling: SettingsUtils.isSettingsApplication

    signal accountClicked(int accountId, string providerName)
    signal accountRemoveRequested(int accountId)
    signal accountSyncRequested(int accountId)
    signal removeRemorseCreated

    //-------------- impl

    property bool _hideJollaAccount

    model: AccountModel { id: accountModel }

    delegate: AccountsListDelegate {
        id: delegateItem

        enabled: root.entriesInteractive
        visible: !root._hideJollaAccount || model.providerName !== "jolla"
        entriesInteractive: root.entriesInteractive
        _settingsApplicationStyling: root._settingsApplicationStyling

        onAccountSyncRequested: root.accountSyncRequested(accountId)
        onAccountRemoveRequested: root.accountRemoveRequested(accountId)
        onAccountClicked: root.accountClicked(accountId, providerName)
        onRemoveRemorseCreated: removeRemorseCreated()
    }

    AccountSyncManager {
        id: accountSyncManager
    }

    AccountManager { id: accountManager }
    VerticalScrollDecorator {}
}
