/**
 * SPDX-FileCopyrightText: 2022-2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#ifndef SAILFISH_MDM_DEVICELOCK_P_H
#define SAILFISH_MDM_DEVICELOCK_P_H

#include "mdm-devicelock.h"

namespace Sailfish {
namespace Mdm {

class DeviceLockPrivate : public QObject
{
    Q_OBJECT
    Q_DISABLE_COPY(DeviceLockPrivate)
    Q_DECLARE_PUBLIC(DeviceLock)

public:
    explicit DeviceLockPrivate(DeviceLock *q);
    ~DeviceLockPrivate();

public slots:
    void onSettingLockoutWarningFinished(int err);
    void onSecurityCodeChangeError(int err);
    void onSecurityCodeUidChangeError(int err);
    void onExpirePasswordError(int err);
    void onSetOneTimePasswordError(int err);
    void onClearPasswordError(int err);

public:
    DeviceLock *q_ptr;
    QDBusInterface iface;
    QDBusInterface proxySysInfoIface;
};

}
}

#endif // SAILFISH_MDM_DEVICELOCK_P_H
