/*
 * SPDX-FileCopyrightText: Copyright 2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

import QtQuick 2.6
import ru.auroraos.WebView.Private 1.0

MouseInput {
    id: mouseInput

    signal scrolled(var x, var y, var deltaX, var deltaY)

    anchors.fill: parent

    MouseArea {
        id: mouseArea

        x: 0
        y: 0
        anchors.fill: parent
        enabled: true
        hoverEnabled: true

        cursorShape: mouseInput.cursorShape 

        onWheel: {
            mouseInput.wheelScrolled(wheel.x, wheel.y, wheel.angleDelta.x, wheel.angleDelta.y)
            mouseInput.scrolled(wheel.x, wheel.y, wheel.angleDelta.x, wheel.angleDelta.y)
        }

        onPositionChanged: {
            mouseInput.mouseMoved(mouseX, mouseY)  
        }
    }
}
