/*****************************************************************************************
**
** SPDX-FileCopyrightText: Copyright 2023 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: LGPLv2
**
******************************************************************************************/

#ifndef APPDIR_H
#define APPDIR_H

#ifdef __cplusplus
extern "C" {
#endif

typedef enum {
    AppCacheLocation = 0,
    AppDataLocation,
    AppLocalCacheLocation,
    AppLocalDataLocation,
    DesktopLocation,
    DocumentsLocation,
    DownloadLocation,
    FontsLocation,
    HomeLocation,
    MoviesLocation,
    MusicLocation,
    OrgCacheLocation,
    OrgDataLocation,
    OrgFilesLocation,
    OrgLocalCacheLocation,
    OrgLocalDataLocation,
    PackageFilesLocation,
    PicturesLocation,
    RemovableMediaLocation,
    RuntimeLocation,
    TempLocation,
    TranslationLocation,
} PathType;

const char *appdir_get_org_name();
const char *appdir_get_app_name();

char *appdir_get_path(PathType type);

#ifdef __cplusplus
}
#endif

#endif // APPDIR_H
