/*
 * SPDX-FileCopyrightText: 2029-2025 Open Mobile Platform LLC <community@omp.ru>
 *
 * SPDX-License-Identifier: Proprietary
*/

import QtQuick 2.6
import Sailfish.Silica 1.0
import Sailfish.Silica.Background 1.0

FilteredImage {
    property int colorScheme: typeof palette === "object" ? palette.colorScheme : Theme.colorScheme
    property string wallpaperFilter: Theme._wallpaperFilter
    property list<QtObject> explicitFilters

    filtering: true
    filters: explicitFilters.length > 0
            ? explicitFilters
            : [Filters[wallpaperFilter]
               || Filters["auroraBlur" + ["Dark", "Light"][colorScheme]]
              ]
}
