/****************************************************************************
**
** SPDX-FileCopyrightText: Copyright 2021-2024 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: Proprietary
**
** Copyright (C) 2017 - 2018 Jolla Ltd.
**
****************************************************************************/

import QtQuick 2.0
import Sailfish.Silica 1.0
import Sailfish.Silica.private 1.0 as Private
import Sailfish.Pickers 1.0
import Aurora.Controls 1.0
import "private"

PickerDialog {
    id: filePicker

    property var nameFilters: []
    // Qt::CaseSensitivity
    property int caseSensitivity: Qt.CaseInsensitive

    property alias showSystemFiles: partitionList.showSystemFiles

    //% "Select location"
    property string title: qsTrId("components_pickers-he-select_location")

    property var _maskedAcceptDestination: pageStack.previousPage()

    acceptDestinationAction: PageStackAction.Pop
    forwardNavigation: _selectedCount > 0
    acceptDestination: forwardNavigation ? _maskedAcceptDestination : null

    orientationTransitions: Private.PageOrientationTransition {
        fadeTarget: _background ? listView : __silica_applicationwindow_instance.contentItem
        targetPage: filePicker
    }

    AppBar {
        id: appBar

        headerText: title
        // When we already have selectedContent - hide the AppBar and show only the DialogHeader
        opacity: _selectedCount > 0 ? 0 : 1
        enabled: _selectedCount <= 0
    }

    PartitionListView {
        id: partitionList

        anchors.topMargin: _selectedCount > 0 ? 0 : appBar.height + Theme.paddingMedium + SafeZoneRect.insets.top
        header: Loader {
            width: parent.width

            sourceComponent: _selectedCount > 0 ? dialogHeader : emptyItem

            Component {
                id: emptyItem
                Item {}
            }

            Component {
                id: dialogHeader
                PickerDialogHeader {
                    showBack: !_clearOnBackstep
                    selectedCount: _selectedCount
                    _glassOnly: _background
                }
            }
        }

        onSelected: {
            var obj = pageStack.animatorPush('private/DirectoryDialog.qml', {
                                                 acceptText: filePicker.acceptText,
                                                 path: info.path,
                                                 nameFilters: filePicker.nameFilters,
                                                 caseSensitivity: filePicker.caseSensitivity,
                                                 acceptDestination: filePicker._maskedAcceptDestination,
                                                 acceptDestinationAction: filePicker.acceptDestinationAction,
                                                 _selectedModel: filePicker._selectedModel,
                                                 _animationDuration: filePicker._animationDuration,
                                                 _background: filePicker._background,
                                                 allowedOrientations: page.allowedOrientations
                                             })

            obj.pageCompleted.connect(function(page) {
                page.accepted.connect(function() {
                    filePicker._dialogDone(DialogResult.Accepted)
                })
            })
        }
    }
}
