/*
 * Copyright (c) 2018 - 2020 Jolla Ltd.
 *
 * License: Proprietary
 */

#ifndef SAILFISH_MDM_SIMVOICECALLFILTER_H
#define SAILFISH_MDM_SIMVOICECALLFILTER_H

#include <QObject>

#include "mdm-simfilter.h"

namespace Sailfish {
namespace Mdm {
class SimVoiceCallFilterPrivate;

class Q_DECL_EXPORT SimVoiceCallFilter : public QObject
{
    Q_OBJECT
    Q_PROPERTY(bool ready READ ready NOTIFY readyChanged)
    Q_PROPERTY(SimFilter::Action defaultDialAction READ defaultDialAction WRITE setDefaultDialAction NOTIFY defaultDialActionChanged)
    Q_PROPERTY(SimFilter::Action defaultIncomingAction READ defaultIncomingAction WRITE setDefaultIncomingAction NOTIFY defaultIncomingActionChanged)
    Q_PROPERTY(SimFilter::RuleList dialRules READ dialRules WRITE setDialRules NOTIFY dialRulesChanged)
    Q_PROPERTY(SimFilter::RuleList incomingRules READ incomingRules WRITE setIncomingRules NOTIFY incomingRulesChanged)

public:
    SimVoiceCallFilter(QObject *parent = 0);
    ~SimVoiceCallFilter();

    bool ready() const;

    // outgoing call (Dial) rules
    SimFilter::Action defaultDialAction() const;
    bool setDefaultDialAction(SimFilter::Action action);

    SimFilter::RuleList dialRules() const;
    bool setDialRules(const SimFilter::RuleList &rules);
    bool clearDialRules();

    bool setDialRule(const SimFilter::Rule &rule);
    bool removeDialRule(const QString &imsi);
    bool hasDialRuleForImsi(const QString &imsi) const;

    // incoming call rules
    SimFilter::Action defaultIncomingAction() const;
    bool setDefaultIncomingAction(SimFilter::Action action);

    SimFilter::RuleList incomingRules() const;
    bool setIncomingRules(const SimFilter::RuleList &rules);
    bool clearIncomingRules();

    bool setIncomingRule(const SimFilter::Rule &rule);
    bool removeIncomingRule(const QString &imsi);
    bool hasIncomingRuleForImsi(const QString &imsi) const;

Q_SIGNALS:
    void readyChanged();

    void defaultDialActionChanged();
    void dialRuleAdded(const Sailfish::Mdm::SimFilter::Rule &rule);
    void dialRuleRemoved(const QString &imsi);
    void dialRulesChanged(const Sailfish::Mdm::SimFilter::RuleList &oldRules, const Sailfish::Mdm::SimFilter::RuleList &newRules);

    void defaultIncomingActionChanged();
    void incomingRuleAdded(const Sailfish::Mdm::SimFilter::Rule &rule);
    void incomingRuleRemoved(const QString &imsi);
    void incomingRulesChanged(const Sailfish::Mdm::SimFilter::RuleList &oldRules, const Sailfish::Mdm::SimFilter::RuleList &newRules);

private:
    SimVoiceCallFilterPrivate *d;
    Q_DISABLE_COPY(SimVoiceCallFilter)
    Q_DECLARE_PRIVATE(SimVoiceCallFilter)
};

}
}

#endif // SAILFISH_MDM_SIMVOICECALLFILTER_H
