/*
 * SPDX-FileCopyrightText: 2018-2020 Jolla Ltd
 * SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#ifndef SAILFISH_MDM_SIMFILTER_P_H
#define SAILFISH_MDM_SIMFILTER_P_H

#include "mdm-simfilter.h"

#include <QDBusArgument>
#include <QDBusPendingCall>

#include <QList>

namespace Sailfish {
namespace Mdm {

class SimFilterPrivate : public QObject
{
    Q_OBJECT
public:
    enum FilterType {
        Sms = 0,
        OutcomingCalls,
        IncomingCalls,
        MobileData,
    };
    Q_ENUM(FilterType)

    struct RulePrivate {
        bool operator==(const RulePrivate &other) const;

        QString imsi;
        quint32 action;
    };
    typedef QList<RulePrivate> RulePrivateList;

    static void registerTypes();
};

}
}

QDBusArgument &operator<<(QDBusArgument &, const Sailfish::Mdm::SimFilterPrivate::RulePrivate &);
const QDBusArgument &operator>>(const QDBusArgument &, Sailfish::Mdm::SimFilterPrivate::RulePrivate &);

QDBusArgument &operator<<(QDBusArgument &, const Sailfish::Mdm::SimFilterPrivate::RulePrivateList &);
const QDBusArgument &operator>>(const QDBusArgument &, Sailfish::Mdm::SimFilterPrivate::RulePrivateList &);

Q_DECLARE_METATYPE(Sailfish::Mdm::SimFilterPrivate::FilterType)
Q_DECLARE_METATYPE(Sailfish::Mdm::SimFilterPrivate::RulePrivate)
Q_DECLARE_METATYPE(Sailfish::Mdm::SimFilterPrivate::RulePrivateList)

#endif // SAILFISH_MDM_SIMFILTER_P_H
