/*
 * Copyright (c) 2018 - 2020 Jolla Ltd.
 *
 * License: Proprietary
 */

#ifndef SAILFISH_MDM_NETWORKDATACOUNTER_H
#define SAILFISH_MDM_NETWORKDATACOUNTER_H

#include <QObject>
#include <QDateTime>

namespace Sailfish {
namespace Mdm {

class NetworkDataCounterPrivate;

class Q_DECL_EXPORT NetworkDataCounter : public QObject
{
    Q_OBJECT
    Q_PROPERTY(int updateInterval READ updateInterval WRITE setUpdateInterval NOTIFY updateIntervalChanged)
    Q_PROPERTY(int updateAccuracy READ updateAccuracy WRITE setUpdateAccuracy NOTIFY updateAccuracyChanged)
    Q_PROPERTY(bool active READ active WRITE setActive NOTIFY activeChanged)

public:
    enum NetworkType {
        MobileDataHome,
        MobileDataRoaming,
        Wlan
    };
    Q_ENUM(NetworkType)

    struct Update
    {
        QString servicePath;
        NetworkType networkType = MobileDataHome;
        quint64 bytesSent = 0;
        quint64 bytesReceived = 0;
        quint64 timeOnline = 0;
    };

    explicit NetworkDataCounter(QObject *parent = 0);
    ~NetworkDataCounter();

    int updateInterval() const;
    void setUpdateInterval(int updateInterval);

    int updateAccuracy() const;
    void setUpdateAccuracy(int updateAccuracy);

    bool active() const;
    void setActive(bool active);

    void resetCounter(const QString &servicePath);

Q_SIGNALS:
    void updateIntervalChanged();
    void updateAccuracyChanged();
    void activeChanged();

    void counterUpdate(const Sailfish::Mdm::NetworkDataCounter::Update &update);

private:
    friend class NetworkDataCounterPrivate;
    Q_DISABLE_COPY(NetworkDataCounter)
    NetworkDataCounterPrivate *d;
};

}
}

#endif // SAILFISH_MDM_NETWORKDATACOUNTER_H
