/****************************************************************************************
**
** SPDX-FileCopyrightText: 2015-2019 Jolla Ltd
** SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: BSD-3-Clause
**
****************************************************************************************/

import QtQuick 2.0
import Sailfish.Silica 1.0
import Nemo.Configuration 1.0

Column {
    id: clock

    property date time

    property int hourMode: timeFormatConfig.value === "24" ? DateTime.TwentyFourHours
                                                           : DateTime.TwelveHours

    Label {
        id: timeText


        font.pixelSize: Theme.fontSizeExtraLarge
        text: hourMode === DateTime.TwentyFourHours
              ? Format.formatDate(time, Format.TimeValueTwentyFourHours)
              : Qt.formatTime(time, "h:mm AP").slice(0, -3)
    }

    Label {
        anchors.horizontalCenter: parent.horizontalCenter
        visible: hourMode !== DateTime.TwentyFourHours
        opacity: Theme.opacityOverlay
        font.pixelSize: Theme.fontSizeExtraSmall

        text: time.getHours() < 12
              //% "AM"
              ? qsTrId("jolla-clock-la-am")
              //% "PM"
              : qsTrId("jolla-clock-la-pm")
    }

    ConfigurationValue {
        id: timeFormatConfig

        key: "/sailfish/i18n/lc_timeformat24h"
    }
}
