/****************************************************************************************
**
** SPDX-FileCopyrightText: 2013 Jolla Ltd.
** SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: BSD-3-Clause
**
****************************************************************************************/

import QtQuick 2.0
import Sailfish.Silica 1.0
import Sailfish.Silica.private 1.0 as Private
import "private"

Private.SilicaMouseArea {
    property alias icon: image
    property bool down: pressed && containsMouse
    property bool _showPress: highlighted || pressTimer.running

    highlighted: down
    cursorShape: enabled ? Qt.PointingHandCursor : Qt.ArrowCursor

    onPressedChanged: {
        if (pressed) {
            pressTimer.start()
        }
    }
    onCanceled: pressTimer.stop()

    width: Theme.itemSizeSmall; height: Theme.itemSizeSmall

    Icon {
        id: image

        highlighted: _showPress
        anchors.centerIn: parent
        opacity: parent.enabled ? 1.0 : Theme.opacityLow
    }
    Timer {
        id: pressTimer
        interval: Theme.minimumPressHighlightTime
    }
}
