/**
 * Copyright (C) 2013 Jolla Ltd.
 * SPDX-FileCopyrightText: Copyright 2023 - 2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */
 
import QtQuick 2.6
import QtGraphicalEffects 1.0
import Sailfish.Silica 1.0
import Sailfish.Media 1.0

Image {
    id: root

    property real sourceSizeMax
    property real defaultArtMargins
    property alias defaultArtOpacity: defaultArt.opacity
    property alias isDefaultArt: defaultArt.visible

    height: width
    cache: true

    sourceSize {
        width: sourceSizeMax
        height: sourceSizeMax
    }

    Image {
        id: defaultArt

        anchors {
            fill: root
            margins: root.defaultArtMargins
        }

        visible: root.status !== Image.Ready
        cache: true
        source: Images.defaultAlbumArt
    }

    Component.onCompleted: if (sourceSizeMax === 0) sourceSizeMax = width
}
