/****************************************************************************
**
** Copyright (c) 2023 Open Mobile Platform LLC
**
** License: Proprietary
****************************************************************************/

import QtQuick 2.5
import Sailfish.Silica 1.0

Item {
    id: root

    property alias listView: firstRamp.sourceItem
    readonly property bool _oversize: (listView.orientation === ListView.Horizontal ? listView.contentWidth > listView.width
                                                                          : listView.contentHeight > listView.height) + 10
    readonly property real _pixelPosition: listView.orientation === ListView.Horizontal ? listView.contentX - listView.originX
                                                                              : listView.contentY - listView.originY
    readonly property real _slopeMax: listView.orientation === ListView.Horizontal ? 1 + 6 * root.width / Screen.width
                                                                                  // Vertical ramps also use Screen.width because
                                                                                  // the screen geometry isn't rotated together with the app
                                                                                  : 1 + 6 * root.height / Screen.width
    readonly property real _firstSlopeMin: Screen.width / Math.max(1, _pixelPosition)
    readonly property real _secondSlopeMin: Screen.width / Math.max(1, (listView.orientation === ListView.Horizontal
                                                                            ? listView.contentWidth - listView.width
                                                                            : listView.contentHeight - listView.height)
                                                                        - _pixelPosition)
    readonly property real _firstSlopeEnabled: _oversize && listView.orientation === ListView.Horizontal
                                                                ? listView.visibleArea.xPosition > 0
                                                                : listView.visibleArea.yPosition > 0
    readonly property real _secondSlopeEnabled: _oversize && listView.orientation === ListView.Horizontal
                                                                ? listView.visibleArea.xPosition < 0.9999 - listView.visibleArea.widthRatio
                                                                : listView.visibleArea.yPosition < 0.9999 - listView.visibleArea.heightRatio

    anchors.fill: listView

    OpacityRampEffect {
        id: firstRamp

        anchors.fill: root
        sourceItem: root.listView
        enabled: _firstSlopeEnabled

        direction: root.listView.orientation === ListView.Horizontal ? OpacityRamp.RightToLeft : OpacityRamp.BottomToTop

        slope: Math.max(
                root._slopeMax,
                root._firstSlopeMin)
        offset: 1 - 1 / slope
    }

    OpacityRampEffect {
        id: secondRamp

        anchors.fill: root
        sourceItem: firstRamp.enabled ? firstRamp : root.listView
        enabled: _secondSlopeEnabled

        direction: root.listView.orientation === ListView.Horizontal ? OpacityRamp.LeftToRight : OpacityRamp.TopToBottom

        slope: Math.max(
                root._slopeMax,
                root._secondSlopeMin)
        offset: 1 - 1 / slope
    }
}
