/****************************************************************************************
**
** SPDX-FileCopyrightText: 2023-2024 Open Mobile Platform LLC <community@omp.ru>
**
** SPDX-License-Identifier: Proprietary
**
****************************************************************************************/

import QtQuick 2.0
import Sailfish.Silica 1.0
import Aurora.Controls.private 1.0

Item {
    property real progress: __pulleyGestureEventFilter ? __pulleyGestureEventFilter.mouseIsOverCancelZoneProgress : 0
    property real zoneDiameter
    property real zoneDiameterMax
    property real zoneCenterPadding

    // There are some variants, when parent could be not defined
    anchors.centerIn: typeof parent === "object" ? parent : undefined

    width: if (parent) rotation % 180 ? parent.height : parent.width
    height: if (parent) rotation % 180 ? parent.width : parent.height

    Item {
        id: cancelIndicator

        property real verticalPosition

        function enable(verticalPos) {
            verticalPosition = verticalPos
            opacity = 1
        }

        y: verticalPosition - height / 2

        width: Math.min(zoneDiameter + (zoneDiameterMax - zoneDiameter) * progress, zoneDiameterMax)

        height: width
        opacity: 0

        Connections {
            target: __pulleyGestureEventFilter

            onStatusChanged: {
                if (__pulleyGestureEventFilter.status === PulleyGestureArea.GestureActive) {
                    if (__pulleyGestureEventFilter.activeEdge === PulleyGestureArea.Left) {
                        cancelIndicator.anchors.horizontalCenter = cancelIndicator.parent.left
                        cancelIndicator.anchors.horizontalCenterOffset = zoneCenterPadding
                        cancelIndicator.enable(__pulleyGestureEventFilter.verticalGesture.startCoordinate)
                    } else if (__pulleyGestureEventFilter.activeEdge === PulleyGestureArea.Right) {
                        cancelIndicator.anchors.horizontalCenter = cancelIndicator.parent.right
                        cancelIndicator.anchors.horizontalCenterOffset = -zoneCenterPadding
                        cancelIndicator.enable(__pulleyGestureEventFilter.verticalGesture.startCoordinate)
                    }
                } else {
                    cancelIndicator.opacity = 0
                }
            }
        }

        Behavior on opacity { FadeAnimation {} }
        Behavior on width {
            NumberAnimation {
                duration: 100
                easing.type: Easing.InOutQuad
            }
        }

        Rectangle {
            property real blend: Theme.colorScheme === Theme.LightOnDark ? 0 : 1
            property real blendOpacity: progress === 1 ? 0.6 : 0.9

            anchors.fill: parent
            color: Qt.rgba(Theme.highlightColor.r * (1 - blendOpacity) + blend * blendOpacity,
                           Theme.highlightColor.g * (1 - blendOpacity) + blend * blendOpacity,
                           Theme.highlightColor.b * (1 - blendOpacity) + blend * blendOpacity)
            radius: width / 2
            border {
                color: Theme.rgba(Theme.primaryColor, 0.2)
                width: Theme.dp(1)
            }

            Behavior on color {
                ColorAnimation {
                    duration: 150
                }
            }
        }

        Icon {
            id: icon

            anchors.centerIn: parent
            sourceSize: Qt.size(Theme.dp(32), Theme.dp(32))

            source: "image://theme/icon-s-clear-opaque-cross"

            highlighted: progress == 1
        }
    }
}

