/*
 * SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#ifndef MDMWIFINETWORKSERVICE_H
#define MDMWIFINETWORKSERVICE_H

#include "mdm-networkservice.h"

namespace Aurora {
namespace Mdm {
namespace Connectivity {

class Q_DECL_EXPORT WifiNetworkService : public NetworkService
{
    Q_OBJECT

    Q_PROPERTY(EapMethod eapMethod READ eapMethod WRITE setEapMethod NOTIFY eapMethodChanged)
    Q_PROPERTY(int peapVersion READ peapVersion WRITE setPeapVersion NOTIFY peapVersionChanged)
    Q_PROPERTY(QString identity READ identity WRITE setIdentity NOTIFY identityChanged)
    Q_PROPERTY(QString passphrase READ passphrase WRITE setPassphrase NOTIFY passphraseChanged)
    Q_PROPERTY(bool eapMethodAvailable READ eapMethodAvailable NOTIFY eapMethodAvailableChanged)
    Q_PROPERTY(bool identityAvailable READ identityAvailable NOTIFY identityAvailableChanged)
    Q_PROPERTY(bool passphraseAvailable READ passphraseAvailable NOTIFY passphraseAvailableChanged)
    Q_PROPERTY(bool phase2Available READ phase2Available NOTIFY phase2AvailableChanged)
    Q_PROPERTY(bool caCertAvailable READ caCertAvailable NOTIFY caCertAvailableChanged)
    Q_PROPERTY(bool caCertFileAvailable READ caCertFileAvailable NOTIFY caCertFileAvailableChanged)
    Q_PROPERTY(bool domainSuffixMatchAvailable READ domainSuffixMatchAvailable NOTIFY domainSuffixMatchAvailableChanged)
    Q_PROPERTY(bool privateKeyAvailable READ privateKeyAvailable NOTIFY privateKeyAvailableChanged)
    Q_PROPERTY(bool privateKeyFileAvailable READ privateKeyFileAvailable NOTIFY privateKeyFileAvailableChanged)
    Q_PROPERTY(bool privateKeyPassphraseAvailable READ privateKeyPassphraseAvailable NOTIFY privateKeyPassphraseAvailableChanged)
    Q_PROPERTY(bool anonymousIdentityAvailable READ anonymousIdentityAvailable NOTIFY anonymousIdentityAvailableChanged)
    Q_PROPERTY(QString bssid READ bssid NOTIFY bssidChanged)
    Q_PROPERTY(quint32 maxRate READ maxRate NOTIFY maxRateChanged)
    Q_PROPERTY(quint16 frequency READ frequency NOTIFY frequencyChanged)
    Q_PROPERTY(QString encryptionMode READ encryptionMode NOTIFY encryptionModeChanged)
    Q_PROPERTY(bool hidden READ hidden NOTIFY hiddenChanged)
    Q_PROPERTY(QString caCert READ caCert WRITE setCACert NOTIFY caCertChanged)
    Q_PROPERTY(QString caCertFile READ caCertFile WRITE setCACertFile NOTIFY caCertFileChanged)
    Q_PROPERTY(QString clientCert READ clientCert WRITE setClientCert NOTIFY clientCertChanged)
    Q_PROPERTY(QString clientCertFile READ clientCertFile WRITE setClientCertFile NOTIFY clientCertFileChanged)
    Q_PROPERTY(QString privateKey READ privateKey WRITE setPrivateKey NOTIFY privateKeyChanged)
    Q_PROPERTY(QString privateKeyFile READ privateKeyFile WRITE setPrivateKeyFile NOTIFY privateKeyFileChanged)
    Q_PROPERTY(QString privateKeyPassphrase READ privateKeyPassphrase WRITE setPrivateKeyPassphrase NOTIFY privateKeyPassphraseChanged)
    Q_PROPERTY(QString domainSuffixMatch READ domainSuffixMatch WRITE setDomainSuffixMatch NOTIFY domainSuffixMatchChanged)
    Q_PROPERTY(QString phase2 READ phase2 WRITE setPhase2 NOTIFY phase2Changed)
    Q_PROPERTY(QString anonymousIdentity READ anonymousIdentity WRITE setAnonymousIdentity NOTIFY anonymousIdentityChanged)
public:
    enum EapMethod {
        EapNone,
        EapPEAP,
        EapTTLS,
        EapTLS
    };

    friend class NetworkManagerPrivate;

    WifiNetworkService(const QString &path, const QVariantMap &properties, QObject* parent);
    ~WifiNetworkService() override;

    QString caCert() const;
    QString caCertFile() const;
    QString clientCert() const;
    QString clientCertFile() const;
    QString domainSuffixMatch() const;
    QString phase2() const;
    QString anonymousIdentity() const;

    bool hidden() const;
    QString bssid() const;
    quint32 maxRate() const;
    quint16 frequency() const;
    QString encryptionMode() const;

    QString passphrase() const;
    void setPassphrase(QString passphrase);
    bool passphraseAvailable() const;

    QString privateKey() const;
    void setPrivateKey(const QString &privateKey);
    bool privateKeyAvailable() const;

    QString privateKeyFile() const;
    void setPrivateKeyFile(const QString &privateKeyFile);
    bool privateKeyFileAvailable() const;

    QString privateKeyPassphrase() const;
    void setPrivateKeyPassphrase(const QString &passphrase);
    bool privateKeyPassphraseAvailable() const;

    QString identity() const;
    void setIdentity(QString identity);
    bool identityAvailable() const;

    EapMethod eapMethod() const;
    void setEapMethod(EapMethod method);
    bool eapMethodAvailable() const;
    bool phase2Available() const;
    bool caCertAvailable() const;
    bool caCertFileAvailable() const;
    bool domainSuffixMatchAvailable() const;
    bool anonymousIdentityAvailable() const;

    int peapVersion() const;
    void setPeapVersion(int version);

    void setCACert(const QString &caCert);
    void setCACertFile(const QString &caCertFile);
    void setClientCert(const QString &clientCert);
    void setClientCertFile(const QString &clientCertFile);
    void setDomainSuffixMatch(const QString &domainSuffixMatch);
    void setPhase2(const QString &phase2);
    void setAnonymousIdentity(const QString &anonymousIdentity);

Q_SIGNALS:
    void caCertChanged();
    void caCertFileChanged();
    void clientCertChanged();
    void clientCertFileChanged();
    void privateKeyChanged();
    void privateKeyFileChanged();
    void privateKeyPassphraseChanged();
    void domainSuffixMatchChanged();
    void phase2Changed();
    void anonymousIdentityChanged();
    void bssidChanged();
    void maxRateChanged();
    void frequencyChanged();
    void encryptionModeChanged();
    void hiddenChanged();
    void passphraseChanged();
    void passphraseAvailableChanged();
    void identityChanged();
    void identityAvailableChanged();
    void eapMethodChanged();
    void peapVersionChanged();
    void eapMethodAvailableChanged();
    void phase2AvailableChanged();
    void privateKeyAvailableChanged();
    void privateKeyFileAvailableChanged();
    void privateKeyPassphraseAvailableChanged();
    void caCertAvailableChanged();
    void caCertFileAvailableChanged();
    void domainSuffixMatchAvailableChanged();
    void anonymousIdentityAvailableChanged();

private:
    WifiNetworkService(NetworkServicePrivate* p, QObject* parent = nullptr);
};

} // namespace Connectivity
} // namespace Mdm
} // namespace Aurora

#endif // MDMWIFINETWORKSERVICE_H
