/*
 * Copyright (c) 2017 - 2020 Jolla Ltd.
 *
 * License: Proprietary
 */

#ifndef SAILFISH_MDM_NOTIFICATIONS_SERIALISATION_IMPL_P_H
#define SAILFISH_MDM_NOTIFICATIONS_SERIALISATION_IMPL_P_H

#include <QDBusArgument>
#include <QDBusMetaType>
#include <QtDebug>

#include "mdm-serialisation_impl_p.h"

#ifdef SAILFISH_MDM_PROXY_BUILD
    #define NotificationDataType NotificationInfo::NotificationData
#else
    #define NotificationDataType Sailfish::Mdm::NotificationData
#endif

QDBusArgument &operator<<(QDBusArgument &argument, const NotificationDataType &data)
{
    argument.beginStructure();
    argument << data.id;
    argument << data.itemCount;
    argument << data.category;
    argument << data.appName;
    argument << data.appIcon;
    argument << data.summary;
    argument << data.body;
    argument << data.previewSummary;
    argument << data.previewBody;
    argument << data.timestamp;
    argument << data.remoteActions;
    argument.endStructure();
    return argument;
}

const QDBusArgument &operator>>(const QDBusArgument &argument, NotificationDataType &data)
{
    QVariantList remoteActions, expandedRemoteActions;
    argument.beginStructure();
    argument >> data.id;
    argument >> data.itemCount;
    argument >> data.category;
    argument >> data.appName;
    argument >> data.appIcon;
    argument >> data.summary;
    argument >> data.body;
    argument >> data.previewSummary;
    argument >> data.previewBody;
    argument >> data.timestamp;
    argument >> remoteActions;
    argument.endStructure();
    if (expandVariantList(remoteActions, &expandedRemoteActions, 0)) {
        data.remoteActions = expandedRemoteActions;
    } else {
        qWarning() << "Failed to expand remote actions from notification";
    }
    return argument;
}

#endif // SAILFISH_MDM_NOTIFICATIONS_SERIALISATION_IMPL_P_H
