// SPDX-FileCopyrightText: 2023-2025 Open Mobile Platform LLC <community@omp.ru>
// SPDX-License-Identifier: LGPL-3.0-only

#ifndef QWAYLANDLIFECYCLE_P_H
#define QWAYLANDLIFECYCLE_P_H

#include <QObject>

QT_BEGIN_NAMESPACE

namespace QtWaylandClient {

class QWaylandLifecycle : public QObject
{
    Q_OBJECT

public:
    QWaylandLifecycle();

    bool isEnabled() const { return m_isEnabled; }

private Q_SLOTS:
    void onStateChanged(const QString &appInstanceId, quint32 state);

private:
    void handleStateChange(quint32 state);

    bool m_isEnabled;
};

} // namespace QtWaylandClient

QT_END_NAMESPACE

#endif // QWAYLANDLIFECYCLE_P_H
