/*
 * Copyright (c) 2018 - 2020 Jolla Ltd.
 *
 * License: Proprietary
 */

#ifndef SAILFISH_MDM_SIMMOBILEDATAFILTER_H
#define SAILFISH_MDM_SIMMOBILEDATAFILTER_H

#include <QObject>

#include "mdm-simfilter.h"

namespace Sailfish {
namespace Mdm {
class SimMobileDataFilterPrivate;

class Q_DECL_EXPORT SimMobileDataFilter : public QObject
{
    Q_OBJECT
    Q_PROPERTY(bool ready READ ready NOTIFY readyChanged)
    Q_PROPERTY(SimFilter::Action defaultAction READ defaultAction WRITE setDefaultAction NOTIFY defaultActionChanged)
    Q_PROPERTY(SimFilter::RuleList rules READ rules WRITE setRules NOTIFY rulesChanged)

public:
    SimMobileDataFilter(QObject *parent = 0);
    ~SimMobileDataFilter();

    bool ready() const;

    SimFilter::Action defaultAction() const;
    bool setDefaultAction(SimFilter::Action action);

    SimFilter::RuleList rules() const;
    bool setRules(const SimFilter::RuleList &rules);
    bool clearRules();

    bool setRule(const SimFilter::Rule &rule);
    bool removeRule(const QString &imsi);
    bool hasRuleForImsi(const QString &imsi) const;

Q_SIGNALS:
    void readyChanged();
    void defaultActionChanged();

    void ruleAdded(const Sailfish::Mdm::SimFilter::Rule &rule);
    void ruleRemoved(const QString &imsi);
    void rulesChanged(const Sailfish::Mdm::SimFilter::RuleList &oldRules, const Sailfish::Mdm::SimFilter::RuleList &newRules);

private:
    SimMobileDataFilterPrivate *d;
    Q_DISABLE_COPY(SimMobileDataFilter)
    Q_DECLARE_PRIVATE(SimMobileDataFilter)
};

}
}

#endif // SAILFISH_MDM_SIMMOBILEDATAFILTER_H
