/*
 * SPDX-FileCopyrightText: 2018-2020 Jolla Ltd
 * SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#ifndef SAILFISH_MDM_PROXY_P_H
#define SAILFISH_MDM_PROXY_P_H

#include <QObject>
#include <QDBusInterface>

namespace Sailfish {
namespace Mdm {

class NetProxy;
class NetProxyPrivate : public QObject
{
    Q_OBJECT
    Q_DISABLE_COPY(NetProxyPrivate)
    Q_DECLARE_PUBLIC(NetProxy)
public:
    enum ApplyMode {
        Unset = 0,
        ServiceProxy = 1,
        GlobalProxy = 2
    };

    NetProxyPrivate(NetProxy *parent);

private slots:
    void onGlobalActiveChanged(bool value);
    void onProxyConfigChanged(const QString &identifier);
    void onTypeChanged(uint type, const QString &identifier);
    void onManualProxiesChanged(const QStringList &proxies, const QString &identifier);
    void onManualExclusionsChanged(const QStringList &exclusions, const QString &identifier);
    void onAutomaticUrlChanged(const QString &url, const QString &identifier);

public:
    QString identifier;
    ApplyMode applyMode;
    QDBusInterface iface;
    NetProxy *const q_ptr;

};

} // namespace Mdm
} // namespace Sailfish

#endif // SAILFISH_MDM_PROXY_P_H
