/**
 * SPDX-FileCopyrightText: 2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#ifndef AURORA_MDM_DISPLAYSETTINGS_P_H
#define AURORA_MDM_DISPLAYSETTINGS_P_H

#include "mdm-displaysettings.h"
#include <QDBusInterface>

namespace Aurora {
namespace Mdm {

class DisplaySettingsPrivate : public QObject
{
    Q_OBJECT
    Q_DISABLE_COPY(DisplaySettingsPrivate)
    Q_DECLARE_PUBLIC(DisplaySettings)

public:
    explicit DisplaySettingsPrivate(DisplaySettings *q);
    DisplaySettings *q_ptr;
    QDBusInterface iface;
};

} // namespace Mdm
} // namespace Aurora

#endif // AURORA_MDM_DISPLAYSETTINGS_P_H
