/**
 * SPDX-FileCopyrightText: 2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#ifndef AURORA_MDM_DEVICECONTROL_H
#define AURORA_MDM_DEVICECONTROL_H

#include <QObject>

namespace Aurora {
namespace Mdm {

class DeviceControlPrivate;
class Q_DECL_EXPORT DeviceControl : public QObject
{
    Q_OBJECT

public:

    explicit DeviceControl(QObject *parent = nullptr);
    ~DeviceControl();

    bool reboot();
    bool shutdown();
    quint64 uptimeMsecs();

private:
    DeviceControlPrivate *d_ptr;
    Q_DISABLE_COPY(DeviceControl)
    Q_DECLARE_PRIVATE(DeviceControl)
};

} // namespace Mdm
} // namespace Aurora

#endif // AURORA_MDM_DEVICECONTROL_H
