/****************************************************************************************
**
** SPDX-FileCopyrightText: 2013 Jolla Ltd.
** SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: BSD-3-Clause
**
****************************************************************************************/

import QtQuick 2.0
import Sailfish.Silica 1.0
import Sailfish.Silica.private 1.0
import "private"

TextBase {
    id: textArea

    property alias text: preeditText.text
    property alias textWidth: textEdit.width
    property alias readOnly: textEdit.readOnly
    property alias inputMethodHints: textEdit.inputMethodHints
    property alias inputMethodComposing: textEdit.inputMethodComposing
    property alias cursorPosition: textEdit.cursorPosition
    property alias wrapMode: textEdit.wrapMode
    property alias verticalAlignment: textEdit.verticalAlignment
    property alias selectedText: textEdit.selectedText
    property alias selectionStart: textEdit.selectionStart
    property alias selectionEnd: textEdit.selectionEnd
    property alias length: textEdit.length

    onHorizontalAlignmentChanged: {
        if (explicitHorizontalAlignment) {
            textEdit.horizontalAlignment = horizontalAlignment
        }
    }
    onExplicitHorizontalAlignmentChanged: {
        if (explicitHorizontalAlignment) {
            textEdit.horizontalAlignment = horizontalAlignment
        } else {
            textEdit.horizontalAlignment = undefined
        }
    }

    _editor: textEdit

    onReadOnlyChanged: _updateBackground()

    _flickableDirection: Flickable.VerticalFlick

    TextEdit {
        id: textEdit
        objectName: "textEditor"

        onHorizontalAlignmentChanged: textArea.setImplicitHorizontalAlignment(horizontalAlignment)

        x: -parent.contentX + textArea.textLeftPadding
        y: -parent.contentY + textArea.textTopPadding
        width: textArea.width - Theme.paddingSmall - textArea._totalLeftMargins
               - textArea._totalRightMargins - textArea._rightItemWidth
        focus: true
        activeFocusOnPress: false
        color: textArea.color
        selectionColor: Theme.rgba(textArea.palette.highlightColor, 0.2)
        selectedTextColor: textArea.palette.highlightColor
        font: textArea.font
        cursorDelegate: Cursor {
            color: textArea.cursorColor
            preedit: preeditText
        }
        wrapMode: TextEdit.Wrap

        // Note: need to disable if textFormat is ever allowed to be more than TextEdit.PlainText
        PreeditText {
            id: preeditText

            onTextChanged: textArea._fixupScrollPosition()
        }
    }
}
