/*
 * SPDX-FileCopyrightText: 2017 Jolla Ltd.
 * SPDX-FileCopyrightText: 2022-2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

import QtQuick 2.0
import Sailfish.Silica 1.0

DialogHeader {
    id: header

    property bool showBack
    property bool singleSelectionMode
    property int selectedCount
    property bool fileSystemAccepted
    readonly property bool largeScreen: Screen.sizeCategory > Screen.Medium

    //: Dialog header cancel text as "Back"
    //% "Back"
    cancelText: showBack ? qsTrId("components_pickers-he-multiselect_dialog_back") : defaultCancelText
    spacing: Theme.paddingMedium
    acceptText: {
        //: Fallback variant when no items selected.
        //% "Accept"
        var text = dialog.acceptText.length ? dialog.acceptText : qsTrId("components_pickers-he-attach_none")

        if (singleSelectionMode) {
            return text
        } else {
            //: Multi content picker number of selected content items
            //% "Accept %n"
            return selectedCount ? qsTrId("components_pickers-he-multipicker_attach", selectedCount) : text
        }
    }
}
