/*
 * SPDX-FileCopyrightText: 2020 Jolla Ltd
 * SPDX-FileCopyrightText: 2022-2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

import QtQuick 2.0
import Sailfish.Silica 1.0
import com.jolla.settings 1.0

BackgroundItem {
    id: addItem

    property bool checked
    property bool _settingsApplicationStyling: false

    width: parent.width
    height: Math.max(Theme.itemSizeSmall, label.height + 2 * Theme.paddingMedium)

    Image {
        id: icon

        anchors.verticalCenter: parent.verticalCenter
        x: SettingsUtils.isSettingsApplication ? Theme.paddingMedium : Theme.horizontalPageMargin
        source: "image://theme/icon-m-add" + (addItem.highlighted ? "?" + Theme.highlightColor : "")
    }

    Label {
        id: label

        anchors {
            left: icon.right
            leftMargin: _settingsApplicationStyling ? Theme.paddingMedium : Theme.paddingLarge
            verticalCenter: parent.verticalCenter
            right: parent.right
            rightMargin: Theme.horizontalPageMargin
        }

        //: Initiates adding a new account
        //% "Add account"
        text: qsTrId("components_accounts-me-add_account")
        truncationMode: TruncationMode.Fade
        color: addItem.highlighted ? Theme.highlightColor : Theme.primaryColor
    }

    Component.onCompleted: {
        if (!_settingsApplicationStyling) {
            return
        }

        contentItem.color = Qt.binding(function() {
            return root._showPress || addItem.checked
                    ? Theme.rgba(palette.highlightBackgroundColor, Theme.opacityFaint)
                    : "transparent"
        })
        contentItem.radius = Theme.paddingSmall
        contentItem.height = Theme.itemSizeSmall
        contentItem.anchors.left = Qt.binding(function() { return contentItem.parent.left })
        contentItem.anchors.right = Qt.binding(function() { return contentItem.parent.right })
        contentItem.anchors.leftMargin = Theme.horizontalPageMargin
        contentItem.anchors.rightMargin = Theme.horizontalPageMargin
        contentItem.anchors.verticalCenter = Qt.binding(function() { return contentItem.parent.verticalCenter })
    }
}
