/**
 * SPDX-FileCopyrightText: 2022-2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#ifndef SAILFISH_MDM_SYSTEMUPDATE_P_H
#define SAILFISH_MDM_SYSTEMUPDATE_P_H

#include "mdm-systemupdate.h"
#include "mdm-settings.h"

#include <QTimer>
#include <systemupdate/client.h>

namespace Sailfish {
namespace Mdm {

class SystemUpdatePrivate : public QObject
{
    Q_OBJECT
    Q_DISABLE_COPY(SystemUpdatePrivate)
    Q_DECLARE_PUBLIC(SystemUpdate)
public:
    enum class Status {
        Idle = 0,
        Checking,
        ChangingMethod,
        DownloadingVD,
        DownloadingOS
    };

    explicit SystemUpdatePrivate(SystemUpdate *q);

    void downloadUpdate(const QString &version, SystemUpdate::Method method,
                        const QString &vendorDataUrl);

    void setReady(bool ready);

    SystemUpdate *q_ptr;
    QScopedPointer<SystemUpdateManager::Client> client;
    SystemUpdate::Method targetMethod = SystemUpdate::Method::Any;
    bool ready = false;
    int downloadProgress = 0;
    QString vendorDataUrl;
    Status status = Status::Idle;

public slots:
    void onStatusChanged();
    void onError(int error, const QString &details);
    void onAvailableVersionsReady(QVector<SystemUpdateManager::VersionEntry> listOfVersionsAvailable);
    void onDownloadProgress(int downloadProgress);
    void onDownloadedChanged();
    void onScheduledChanged(int action);
    void onScheduleCancelled(int action);
};

}
}

#endif // SAILFISH_MDM_SYSTEMUPDATE_P_H
