/**
 * SPDX-FileCopyrightText: 2024-2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#ifndef SAILFISH_MDM_BATTERYINFO_P_H
#define SAILFISH_MDM_BATTERYINFO_P_H

#include "mdm-batteryinfo.h"

#include <QObject>
#include <QDBusInterface>

class BatteryStatusPrivate : public QObject
{
    Q_OBJECT
    Q_DISABLE_COPY(BatteryStatusPrivate)
    Q_DECLARE_PUBLIC(BatteryStatus)

public:
    explicit BatteryStatusPrivate(BatteryStatus *q);
    virtual ~BatteryStatusPrivate();

public Q_SLOTS:
    void updateChargerStatus();
    void updateStatus();
    void updateChargePercentage();

public:
    QDBusInterface iface;
    BatteryStatus *q_ptr;
};

#endif // SAILFISH_MDM_BATTERYINFO_P_H
