/****************************************************************************************
**
** SPDX-FileCopyrightText: 2013 Jolla Ltd
** SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: BSD-3-Clause
**
****************************************************************************************/

import QtQuick 2.4
import Sailfish.Silica 1.0
import Sailfish.Silica.private 1.0

SliderBase {
    id: slider

    property color backgroundGlowColor: "transparent"
    property alias label: labelText.text

    _highlightItem: handle
    _backgroundItem: backgroundLine
    _progressBarItem: progressLine

    implicitHeight: layerItem.height

    Item {
        id: layerItem

        width: parent.width
        height: topArea.height + backgroundLine.height + bottomArea.height
        layer.enabled: true

        Item {
            id: topArea

            width: parent.width
            height: slider.valueText
                    ? valueTextPlaceholder.height + Theme.dp(15)
                    : Theme.itemSizeExtraSmall * 0.5 - progressLine.height * 0.5 + Theme.dp(2)

            Label {
                id: valueTextPlaceholder

                width: slider._grooveWidth
                x: {
                    const center = slider._highlightX + (slider.handleVisible ? handle.width * 0.5 : 0.0)
                    const pos = center - implicitWidth * 0.5
                    const minX = Math.max(0.0, slider.leftMargin - Theme.paddingMedium)
                    const maxX = Math.min(slider.width, slider.leftMargin + slider._grooveWidth + Theme.paddingMedium)

                    if ((pos + implicitWidth) > maxX) {
                        pos = maxX - implicitWidth
                    }

                    if (pos < minX) {
                        pos = minX
                    }

                    return pos
                }

                truncationMode: TruncationMode.Fade
                font.pixelSize: Theme.fontSizeMedium
                font.family: Theme.fontFamily
                color: slider.highlighted ? slider.highlightColor : palette.primaryColor
                textFormat: Text.PlainText
                text: slider.valueText
                visible: text
            }
        }

        Rectangle {
            id: backgroundLine

            readonly property real handleWidth: slider.handleVisible ? Theme.dp(36) : 0

            anchors.top: topArea.bottom

            x: slider.handleVisible
               ? handle.x + handleWidth - handle.border.width * 0.5
               : slider.leftMargin
            width: slider.handleVisible
                   ? slider._grooveWidth - progressLine.width - handleWidth + handle.border.width
                   : slider._grooveWidth
            height: Theme.dp(6)
            radius: height * 0.5
            color: slider.backgroundColor
            opacity: Theme.opacityFaint
        }

        Rectangle {
            id: progressLine

            anchors.top: topArea.bottom

            x: slider.leftMargin
            width: slider._highlightX - slider.leftMargin + (slider.handleVisible ? handle.border.width * 0.5 : 0.0)
            height: Theme.dp(6)
            radius: height * 0.5
            color: slider.highlighted ? slider.highlightColor : slider.color
        }

        Rectangle {
            id: handle

            anchors.verticalCenter: backgroundLine.verticalCenter

            x: slider._highlightX
            width: Theme.dp(36)
            height: width
            radius: height * 0.5
            color: "transparent"
            border.color: slider.highlighted ? slider.highlightColor : slider.color
            border.width: Theme.dp(6)
            visible: slider.handleVisible
        }

        Item {
            id: bottomArea

            anchors.top: backgroundLine.bottom

            width: parent.width
            height: slider.label
                    ? Theme.dp(15) + Theme.dp(14) + labelText.height + labelText.anchors.bottomMargin
                    : Math.max(Theme.itemSizeExtraSmall * 0.5 - progressLine.height * 0.5 + Theme.dp(2),
                               topArea.height)

            Label {
                id: labelText

                anchors {
                    bottom: parent.bottom
                    bottomMargin: Theme.dp(2)
                }

                width: parent.width
                horizontalAlignment: implicitWidth > width ? Text.AlignLeft : Text.AlignHCenter
                truncationMode: TruncationMode.Fade
                visible: text
                font.pixelSize: Theme.fontSizeExtraSmall
                font.family: Theme.fontFamily
                color: Theme.secondaryColor
                textFormat: Text.PlainText
            }
        }
    }
}
