/****************************************************************************************
**
** SPDX-FileCopyrightText: 2013 Jolla Ltd.
** SPDX-FileCopyrightText: 2023-2025 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: BSD-3-Clause
**
****************************************************************************************/

import QtQuick 2.0
import Sailfish.Silica 1.0
import Sailfish.Silica.private 1.0

SilicaMouseArea {
    id: item

    property bool down: pressed && containsMouse && !DragFilter.canceled && !pressDelayTimer.running
    property color highlightedColor: Theme.rgba(palette.highlightBackgroundColor, Theme.highlightBackgroundOpacity)
    property alias contentHeight: content.height
    property alias contentWidth: content.width
    property alias contentX: content.x
    property alias _backgroundRadius: content.radius
    property bool _pressEffectDelay: true

    property bool _showPress: highlighted || pressTimer.running
    property alias contentItem: content
    property alias _backgroundColor: content.color
    property real _screenMargin: Theme.paddingLarge

    default property alias children: content.data

    width: parent ? parent.width : Screen.width
    implicitHeight: Theme.itemSizeSmall

    DragFilter.screenMargin: item._screenMargin

    highlighted: down
    cursorShape: enabled ? Qt.PointingHandCursor : Qt.ArrowCursor

    onPressed: item.DragFilter.begin(mouse.x, mouse.y)
    onCanceled: item.DragFilter.end()

    onPreventStealingChanged: if (preventStealing) item.DragFilter.end()

    Rectangle {
        id: content
        width: parent.width
        height: item.height

        color: _showPress ? highlightedColor : "transparent"
    }
    Timer {
        id: pressTimer
        interval: Theme.minimumPressHighlightTime
        running: item.pressed && !pressDelayTimer.running
    }

    Timer {
        id: pressDelayTimer
        interval: 48
        running: item.pressed && item._pressEffectDelay
    }
}
