/**
 * SPDX-FileCopyrightText: 2024-2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#ifndef AURORA_MDM_SYSTEMEVENTS_P_H
#define AURORA_MDM_SYSTEMEVENTS_P_H

#include "mdm-systemevents.h"

#include <QDBusInterface>
#include <QPair>

namespace Aurora {
namespace Mdm {

class SystemEventsPrivate : public QObject
{
    Q_OBJECT
    Q_DISABLE_COPY(SystemEventsPrivate)
    Q_DECLARE_PUBLIC(SystemEvents)

public:
    using Event = SystemEvents::Event;
    using Events = SystemEvents::Events;

    explicit SystemEventsPrivate(SystemEvents *q);

    Events getEvents(quint64 startEventId, quint32 count, bool *hasMore,
                     bool *success);

    QDBusInterface proxyIface;
    quint64 maxCount;
    SystemEvents *q_ptr;
};

} // namespace Mdm
} // namespace Aurora

#endif // AURORA_MDM_SYSTEMEVENTS_P_H
