/*
 * SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#pragma once

namespace {
 
// Acess Point Settings
const auto TypeKey = QStringLiteral("Type");
const auto NameKey = QStringLiteral("Name");
const auto AccessPointNameKey = QStringLiteral("AccessPointName");
const auto UsernameKey = QStringLiteral("Username");
const auto PasswordKey = QStringLiteral("Password");
const auto AuthenticationMethodKey = QStringLiteral("AuthenticationMethod");
const auto ProtocolKey = QStringLiteral("Protocol");
const auto MessageCenterKey = QStringLiteral("MessageCenter");
const auto MessageProxyKey = QStringLiteral("MessageProxy");

namespace Type {

const auto Internet = QStringLiteral("internet");
const auto MMS = QStringLiteral("mms");
const auto IMS = QStringLiteral("ims");

} // namespace Type

namespace Technology {

const auto None = QStringLiteral("none");
const auto PAP = QStringLiteral("pap");
const auto CHAP = QStringLiteral("chap");
const auto Any = QStringLiteral("any");

} // namespace Technology
 
} // anonymous namespace
