/****************************************************************************************
**
** SPDX-FileCopyrightText: Copyright 2023 Open Mobile Platform LLC <community@omp.ru>
**
** SPDX-License-Identifier: Proprietary
**
****************************************************************************************/

pragma Singleton

import QtQuick 2.0

Timer {
    id: root

    property bool colorChanged
    property color oldColor
    property real oldOpacity
    property var activeComponentsArray: []

    property var window

    function restoreStatusBar(immediate, component) {
        if (!window) {
            return
        }

        if (component) {
            const index = activeComponentsArray.indexOf(component)
            if (index > -1) {
                activeComponentsArray.splice(index, 1)
            }
        }

        if (activeComponentsArray.length) {
            // Restore color to first active component
            activeComponentsArray[0]._setStatusBar()
            return
        }

        if (colorChanged) {
            if (immediate) {
                root.stop()
                root.triggered()

                return
            }

            root.restart()
        }
    }

    function setStatusBar(color, opacity, component) {
        if (!window) {
            return
        }

        root.stop()

        if (!colorChanged) {
            oldColor = root.window.__statusbarWatcherColor
            oldOpacity = root.window.__statusbarWatcherOpacity
        }

        if (component && activeComponentsArray.indexOf(component) == -1) {
            activeComponentsArray.push(component)
        }

        root.window.__statusbarWatcherColor = color
        root.window.__statusbarWatcherOpacity = opacity
        colorChanged = true
    }

    onTriggered: {
        if (!window) {
            return
        }

        window.__statusbarWatcherOpacity = oldOpacity
        if (oldOpacity) {
            window.__statusbarWatcherColor = oldColor
        }
        colorChanged = false
    }

    // We need such latency for smooth statusbar coloring if component on next page has another color
    // Otherwise it will be colored to default color and then to component color color
    interval: 500
}
