/****************************************************************************
**
** SPDX-FileCopyrightText: Copyright 2024 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: Proprietary
**
** Copyright (C) 2013-2016 Jolla Ltd.
** Contact: Raine Mäkeläinen <raine.makelainen@jollamobile.com>
**
****************************************************************************/

import QtQuick 2.0
import Sailfish.Silica 1.0
import Sailfish.Silica.private 1.0 as Private
import Aurora.Controls 1.0
import "private"

PickerDialog {
    id: contentPickerDialog

    //% "Select content"
    property string title: qsTrId("components_pickers-he-select_content")

    forwardNavigation: _selectedCount > 0
    orientationTransitions: Private.PageOrientationTransition {
        fadeTarget: _background ? categoryList : __silica_applicationwindow_instance.contentItem
        targetPage: contentPickerDialog
    }

    AppBar {
        id: appBar

        headerText: title
        // When we already have selectedContent - hide the AppBar and show only the DialogHeader
        opacity: _selectedCount > 0 ? 0 : 1
        enabled: _selectedCount <= 0
    }

    SilicaListView {
        id: categoryList

        anchors.fill: parent
        anchors.topMargin: _selectedCount > 0 ? 0 : appBar.height + Theme.paddingMedium + SafeZoneRect.insets.top
        header: Loader {
            width: parent.width

            sourceComponent: _selectedCount > 0 ? dialogHeader : emptyItem

            Component {
                id: emptyItem
                Item {}
            }

            Component {
                id: dialogHeader
                PickerDialogHeader {
                    showBack: !_clearOnBackstep
                    selectedCount: _selectedCount
                    _glassOnly: _background
                }
            }
        }

        model: categoryModel

        delegate: CategoryItem {
            text: categoryModel.category(index)
            iconSource: model.iconSource

            onClicked: {
                var props = {
                    acceptDestinationAction: PageStackAction.Pop,
                    _selectedModel: contentPickerDialog._selectedModel,
                    _animationDuration: contentPickerDialog._animationDuration,
                    _background: contentPickerDialog._background
                }


                // Copy properties from model to the sub-page
                for (var i in model.properties) {
                    props[i] = model.properties[i]
                }

                // Accept destination cannot be set, if forward navigation is not enabled
                if (model.acceptDestination) {
                    props["acceptDestination"] = pageStack.previousPage(contentPickerDialog)
                } else {
                    props["_maskedAcceptDestination"] = pageStack.previousPage(contentPickerDialog)
                }

                var obj = pageStack.animatorPush(Qt.resolvedUrl(model.subview), props,
                                                 pageStack._transitionDuration === 0 ? PageStackAction.Immediate
                                                                                     : PageStackAction.Animated)
                obj.pageCompleted.connect(function(subview) {
                    subview.accepted.connect(function() {
                        contentPickerDialog._dialogDone(DialogResult.Accepted)
                    })
                })
            }
        }

        VerticalScrollDecorator {}
    }

    CategoryModel {
        id: categoryModel
        multiPicker: true
    }
}
