/**
 * SPDX-FileCopyrightText: 2020-2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#ifndef MDM_SMSHISTORY_P_H
#define MDM_SMSHISTORY_P_H

#include "mdm-smshistory.h"
#include "base-mdm-proxy-interface_p.h"
#include <QDBusInterface>
#include <QDBusArgument>

class QDBusPendingCallWatcher;

namespace Sailfish {
namespace Mdm {

class SMSHistoryPrivate : public BaseMdmProxyInterface
{
    Q_OBJECT
public:
    // Must match SMSHistoryProxy::HistoryData
    struct HistoryData {
        qint64 receiveTime = 0;
        QString phoneNumber;
    };

    SMSHistoryPrivate(Sailfish::Mdm::SMSHistory *parent);
    ~SMSHistoryPrivate();

    virtual void customInitProxyPrep();

    Sailfish::Mdm::SMSHistory *q;

public Q_SLOTS:
    void handleSearchFinished(bool success, const QList<Sailfish::Mdm::SMSHistoryPrivate::HistoryData> &dataList);
};

}
}

QDBusArgument &operator<<(QDBusArgument &, const Sailfish::Mdm::SMSHistoryPrivate::HistoryData &);
const QDBusArgument &operator>>(const QDBusArgument &, Sailfish::Mdm::SMSHistoryPrivate::HistoryData &);

Q_DECLARE_METATYPE(Sailfish::Mdm::SMSHistoryPrivate::HistoryData)
Q_DECLARE_METATYPE(QList<Sailfish::Mdm::SMSHistoryPrivate::HistoryData>)

#endif
