/*
 * Copyright (c) 2020 Open Mobile Platform LLC.
 *
 * License: Proprietary
 */

#ifndef MDM_SMSHISTORY_SERIALISATION_IMPL_P_H
#define MDM_SMSHISTORY_SERIALISATION_IMPL_P_H

#include <QDBusArgument>
#include <QDBusMetaType>
#include <QtDebug>

#include "mdm-serialisation_impl_p.h"

#ifdef SAILFISH_MDM_PROXY_BUILD
    #define SMSHistoryResultType SMSHistoryProxy::HistoryData
#else
    #define SMSHistoryResultType Sailfish::Mdm::SMSHistoryPrivate::HistoryData
#endif

QDBusArgument &operator<<(QDBusArgument &argument, const SMSHistoryResultType &data)
{
    argument.beginStructure();
    argument << data.receiveTime;
    argument << data.phoneNumber;
    argument.endStructure();
    return argument;
}

const QDBusArgument &operator>>(const QDBusArgument &argument, SMSHistoryResultType &data)
{
    argument.beginStructure();
    argument >> data.receiveTime;
    argument >> data.phoneNumber;
    argument.endStructure();
    return argument;
}

#endif