/*
 * SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: BSD-3-Clause
 */

import QtQuick 2.0
import Sailfish.Silica 1.0

Rectangle {
    id: root

    property real value
    property int stepCount: 24
    property int rotationRadius
    property real velocity: 30
    property bool animationEnabled: true
    property bool moving
    property bool highlighted
    property Palette palette

    readonly property real angle: (value % stepCount) / stepCount * Math.PI * 2

    width: Theme.dp(36)
    height: width
    radius: width
    color: "transparent"
    border {
        width: Theme.dp(6)
        color: root.highlighted ? Qt.tint(root.palette.highlightColor, Theme.rgba(root.palette.highlightBackgroundColor, Theme.highlightBackgroundOpacity))
                                : root.palette.highlightColor
    }

    transform: Translate {
        x: root.rotationRadius * Math.sin(root.angle)
        y: -root.rotationRadius * Math.cos(root.angle)
    }

    Behavior on value {
        enabled: root.animationEnabled && !root.moving
        SmoothedAnimation { velocity: root.velocity }
    }
}
