// Copyright (C) 2016 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR LGPL-3.0-only OR GPL-2.0-only OR GPL-3.0-only

#ifndef QWAYLANDWINDOW_NATIVEINTERFACE_P_H
#define QWAYLANDWINDOW_NATIVEINTERFACE_P_H

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists purely as an
// implementation detail.  This header file may change from version to
// version without notice, or even be removed.
//
// We mean it.
//

#include <QtGui/private/qtguiglobal_p.h>
#include <QtCore/qrect.h>
#include <QtGui/qwindow.h>

#include <any>

struct wl_surface;

QT_BEGIN_NAMESPACE

class QMargins;

namespace QNativeInterface {

namespace Private {

struct Q_GUI_EXPORT QWaylandWindow : public QObject
{
    Q_OBJECT
public:
    virtual wl_surface *surface() const = 0;
    virtual void setCustomMargins(const QMargins &margins) = 0;
    virtual void requestXdgActivationToken(uint serial) = 0;
    template<typename T>
    T *surfaceRole() const
    {
        std::any anyRole = _surfaceRole();
        auto role = std::any_cast<T *>(&anyRole);
        return role ? *role : nullptr;
    }
Q_SIGNALS:
    void surfaceCreated();
    void surfaceDestroyed();
    void surfaceRoleCreated();
    void surfaceRoleDestroyed();
    void xdgActivationTokenCreated(const QString &token);

protected:
    virtual std::any _surfaceRole() const = 0;
};

} // Private

} // QNativeInterface

QT_END_NAMESPACE

#endif // QWAYLANDWINDOW_NATIVEINTERFACE_P_H
