/****************************************************************************************
**
** SPDX-FileCopyrightText: 2024-2025 Open Mobile Platform LLC <community@omp.ru>
**
** SPDX-License-Identifier: Proprietary
**
****************************************************************************************/

import QtQuick 2.0
import Sailfish.Silica 1.0
import Aurora.Primer.private 1.0
import QtGraphicalEffects 1.0

Popup {
    id: root

    default property alias children: stackColumn.children
    property Palette palette: __silica_applicationwindow_instance.palette
    property alias _backgroundColor: popupBackground.color

    width: Math.min(implicitWidth, contentWidth)
    height: Math.min(implicitHeight, contentHeight)
    contentHeight: Math.max(Math.min(_private.maxHeight, stackColumn.height + Theme.paddingSmall * 2),
                            Theme.dp(72))
    contentWidth: Math.min(stackColumn.width, _private.maxWidth)
    preferredWidth: contentWidth
    preferredHeight: _private.maxHeight

    backgroundItem: RectangularGlow {
        scale: progress
        opacity: progress
        transformOrigin: contentContainer.transformOrigin
        cornerRadius: Theme.dp(24)
        glowRadius: cornerRadius
        color: Theme.colorScheme == Theme.DarkOnLight ? "#19000000" : "#33000000"

        Rectangle {
            id: popupBackground

            anchors.fill: parent

            color: Qt.tint(Theme.rgba(palette.highlightColor, 1.0),
                           palette.colorScheme == Theme.DarkOnLight ? "#ccffffff" : "#cc000000")
            radius: Theme.paddingMedium
            border.width: Theme._lineWidth
            border.color: Theme.rgba(palette.primaryColor, 0.1)
        }
    }

    contentItem: Item {
        id: contentContainer

        width: root.width
        height: root.height

        scale: progress
        opacity: progress
        layer.enabled: true
        layer.effect: OpacityMask {
            maskSource: Rectangle {
                anchors.fill: contentContainer
                visible: false
                color: "black"
                radius: popupBackground.radius * 0.85
            }
        }

        QtObject {
            id: _private

            readonly property real minHeight: Theme.dp(72) * 1
            readonly property real maxHeight: Theme.dp(72) * 6 + Theme.paddingSmall * 5
            readonly property real maxWidth: Theme.dp(528)
        }

        InverseMouseArea {
            anchors.fill: parent

            acceptedButtons: Qt.AllButtons

            onPressedOutside: close()
        }

        MouseArea {
            anchors.fill: parent
            acceptedButtons: Qt.AllButtons
        }

        Flickable {
            id: flickable

            anchors {
                fill: parent
                topMargin: Theme.paddingSmall
                bottomMargin: Theme.paddingSmall
            }
            pixelAligned: true
            flickDeceleration: Theme.flickDeceleration
            maximumFlickVelocity: Theme.maximumFlickVelocity
            boundsBehavior: Flickable.StopAtBounds
            contentHeight: stackColumn.height

            Column {
                id: stackColumn

                spacing: Theme.paddingSmall
            }

            VerticalScrollDecorator {}
        }
    }

    onChildrenChanged: {
        if (children[children.length - 1] && children[children.length - 1].hasOwnProperty("_parentPopup")) {
            children[children.length - 1]._parentPopup = root
        }
    }

    onAboutToHide: flickable.interactive = false
    onAboutToShow: flickable.contentY = 0
    onOpened: flickable.interactive = true
}
