/**
 * SPDX-FileCopyrightText: 2023-2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#ifndef SAILFISH_MDM_USERMANAGER_P_H
#define SAILFISH_MDM_USERMANAGER_P_H

#include <sailfishusermanagerinterface.h>
#include <QDBusInterface>
#include <QVariantMap>

#include "mdm-usermanager.h"

namespace Sailfish {
namespace Mdm {

class UserManager;
class UserManagerPrivate : public QObject
{
    Q_OBJECT
    Q_DISABLE_COPY(UserManagerPrivate)
    Q_DECLARE_PUBLIC(UserManager)
public:
    explicit UserManagerPrivate(UserManager *q);
    ~UserManagerPrivate() = default;

    QList<UserManager::UserEntry> users();
    uint addUserParam(const QVariantMap &settings);

public slots:
    void onUserAdded(const SailfishUserManagerEntry &entry);
    void onStartupFinished();

private:
    friend class UserManager;
    UserManager *q_ptr;
    QDBusInterface m_iface;
};

} // namespace Mdm
} // namespace Sailfish

#endif
