/*
 * SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#ifndef MDMNETWORKSERVICE_P_H
#define MDMNETWORKSERVICE_P_H

#include "mdm-networkservice.h"
#include <networkservice.h>

#include <QObject>
#include <QDBusInterface>
#include <QDBusVariant>

namespace Aurora {
namespace Mdm {
namespace Connectivity {

typedef ::NetworkService NetworkServiceInstance;

class NetworkServicePrivate: public QObject
{
    Q_OBJECT
public:
    // To differentiate between NetworkService and Aurora::Mdm::Connectivity::NetworkService
    using NetService = Aurora::Mdm::Connectivity::NetworkService;
    using OwnerType = NetService::OwnerType;

    NetworkServicePrivate(NetworkServiceInstance* instance, bool owner, NetService *parent = nullptr);
    ~NetworkServicePrivate();

    void updateProperty(const QString &key, const QVariant &value);

private slots:
    void onPropertyChanged(const QString &key, const QDBusVariant &value);

public:
    QDBusInterface iface;
    OwnerType ownerType = OwnerType::OwnerUser;
    NetworkServiceInstance *instance;
    bool owner;
    NetService *q_ptr;
};

} // namespace Connectivity
} // namespace Mdm
} // namespace Aurora

#endif // MDMNETWORKSERVICE_P_H
