/**
 * SPDX-FileCopyrightText: 2017-2020 Jolla Ltd.
 * SPDX-FileCopyrightText: 2020-2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#ifndef SAILFISH_MDM_LOCATIONSETTINGS_P_H
#define SAILFISH_MDM_LOCATIONSETTINGS_P_H

#include "mdm-location.h"
#include "base-mdm-proxy-interface_p.h"
#include "util_p.h"
#include <location-settings-qt5/global-settings.hpp>

#include <QDBusInterface>
#include <QFileSystemWatcher>
#include <QPair>
#include <QTimer>
#include <QObject>
#include <QGeoSatelliteInfoSource>
#include <QGeoPositionInfoSource>
#include <QGeoSatelliteInfo>
#include <QGeoPositionInfo>

namespace Sailfish {
namespace Mdm {

class LocationInfoPrivate : public QObject
{
    Q_OBJECT

public:
    LocationInfoPrivate(LocationInfo *info);

public slots:
    void satellitesInUseUpdated(const QList<QGeoSatelliteInfo> &inUse);
    void satellitesInViewUpdated(const QList<QGeoSatelliteInfo> &inView);
    void positionUpdated(const QGeoPositionInfo &info);

private slots:
    void emitSatellitesChanged();

private:
    friend class LocationInfo;
    LocationInfo *q;
    QGeoSatelliteInfoSource *satellites { Q_NULLPTR };
    QGeoPositionInfoSource *geoclue { Q_NULLPTR };
    QGeoPositionInfo position;
    QPair<int, int> lastEmittedSatellites;
    int satellitesInUse;
    int satellitesInView;
    bool isActive;
};

class LocationSettingsPrivate : public QObject
{
    Q_OBJECT

public:
    LocationSettingsPrivate(LocationSettings *settings);

private:
    friend class LocationSettings;

    Aurora::Location::GlobalSettings m_globalSettings;
};

} // namespace Mdm
} // namespace Sailfish

#endif // SAILFISH_MDM_LOCATIONSETTINGS_P_H
