/*
 * Copyright (c) 2018 - 2020 Jolla Ltd.
 *
 * License: Proprietary
 */

#ifndef SAILFISH_MDM_CALLSTATISTICS_SERIALISATION_IMPL_P_H
#define SAILFISH_MDM_CALLSTATISTICS_SERIALISATION_IMPL_P_H

#include <QDBusArgument>
#include <QDBusMetaType>
#include <QtDebug>

#include "mdm-serialisation_impl_p.h"

#ifdef SAILFISH_MDM_PROXY_BUILD
    #define CallStatisticsResultType CallStatisticsProxy::StatisticData
#else
    #define CallStatisticsResultType Sailfish::Mdm::CallStatisticsPrivate::StatisticData
#endif

QDBusArgument &operator<<(QDBusArgument &argument, const CallStatisticsResultType &data)
{
    argument.beginStructure();
    argument << data.secondsSinceEpoch;
    argument << data.callCount;
    argument.endStructure();
    return argument;
}

const QDBusArgument &operator>>(const QDBusArgument &argument, CallStatisticsResultType &data)
{
    argument.beginStructure();
    argument >> data.secondsSinceEpoch;
    argument >> data.callCount;
    argument.endStructure();
    return argument;
}

#endif // SAILFISH_MDM_CALLSTATISTICS_SERIALISATION_IMPL_P_H

