/*
 * SPDX-FileCopyrightText: 2017-2020 Jolla Ltd
 * SPDX-FileCopyrightText: 2024-2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#ifndef SAILFISH_MDM_BATTERYINFO_H
#define SAILFISH_MDM_BATTERYINFO_H

#include <QObject>

class BatteryStatusPrivate;
class Q_DECL_EXPORT BatteryStatus : public QObject
{
    Q_OBJECT
    Q_ENUMS(ChargerStatus)
    Q_ENUMS(Status)

    Q_PROPERTY(ChargerStatus chargerStatus READ chargerStatus NOTIFY chargerStatusChanged)
    Q_PROPERTY(int chargePercentage READ chargePercentage NOTIFY chargePercentageChanged)
    Q_PROPERTY(Status status READ status NOTIFY statusChanged)

public:
    BatteryStatus(QObject *parent = 0);
    ~BatteryStatus();

    enum ChargerStatus {
        ChargerStatusUnknown = -1,
        Disconnected = 0,
        Connected = 1
    };
    Q_ENUM(ChargerStatus)

    enum Status {
        BatteryStatusUnknown = -1,
        Full = 0,
        Normal = 1,
        Low = 2,
        Empty = 3
    };
    Q_ENUM(Status)

    ChargerStatus chargerStatus() const;
    int chargePercentage() const;
    Status status() const;

signals:
    void chargerStatusChanged(ChargerStatus status);
    void chargePercentageChanged(int percentage);
    void statusChanged(Status status);

private:
    BatteryStatusPrivate *d_ptr;
    Q_DISABLE_COPY(BatteryStatus)
    Q_DECLARE_PRIVATE(BatteryStatus)
};

namespace Sailfish {
namespace Mdm {

class Q_DECL_EXPORT BatteryInfo : public BatteryStatus
{
    Q_OBJECT

public:
    BatteryInfo(QObject *parent = 0);

#ifdef Q_QDOC // to allow QDoc to find the signatures.
    Q_PROPERTY(ChargerStatus chargerStatus READ chargerStatus NOTIFY chargerStatusChanged)
    Q_PROPERTY(int chargePercentage READ chargePercentage NOTIFY chargePercentageChanged)
    Q_PROPERTY(Status status READ status NOTIFY statusChanged)

    enum ChargerStatus {
        Connected,
        Disconnected,
        ChargerStatusUnknown
    };

    enum Status {
        Full,
        Normal,
        Low,
        Empty
    };

    ChargerStatus chargerStatus() const;
    int chargePercentage() const;
    Status status() const;
signals:
    void chargerStatusChanged(ChargerStatus status);
    void chargePercentageChanged(int percentage);
    void statusChanged(Status status);
#endif
};

} // namespace Mdm
} // namespace Sailfish

#endif // SAILFISH_MDM_BATTERYINFO_H
