/*
 * SPDX-FileCopyrightText: Copyright 2023-2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

import QtQuick 2.0
import ru.auroraos.WebView.Global 1.0
import Sailfish.Silica 1.0

Item {
    id: selectionHandle

    property int orientation: HandleHorizontalAlignment.CEF_HORIZONTAL_ALIGNMENT_CENTER
    property int bigRadius: Theme.iconSizeSmall / 2
    property int smallRadius: Theme.dp(3)
    property int handleWidth: Theme.itemSizeExtraSmall
    property color color: Theme.highlightBackgroundColor

    function isLeft() {
        return orientation === HandleHorizontalAlignment.CEF_HORIZONTAL_ALIGNMENT_LEFT
    }

    function isRight() {
        return orientation === HandleHorizontalAlignment.CEF_HORIZONTAL_ALIGNMENT_RIGHT
    }

    function isCenter() {
        return orientation === HandleHorizontalAlignment.CEF_HORIZONTAL_ALIGNMENT_CENTER
    }

    function show() {
        selectionHandle.opacity = 1.0
    }

    function hide() {
        selectionHandle.opacity = 0.0
    }

    function setOpacity(opacity) {
        selectionHandle.opacity = opacity
    }

    function setOrientation(newOrientation) {
        orientation = newOrientation
        canvas.requestPaint()
    }

    function move(newX, newY) {
        selectionHandle.x = newX + (isLeft() ? (handleWidth - selectionHandle.width - 2) :
                                               isCenter() ?
                                                   (handleWidth - selectionHandle.width) / 2:
                                                   0)
        selectionHandle.y = newY
        menu.position |= isLeft() ? menu.positionLeft :
                                    isRight() ? menu.positionRight : 0
    }

    onColorChanged: {
        canvas.requestPaint()
    }

    onOpacityChanged: {
        if (opacity === 0.0)
            menu.position &= isLeft()
                    ? ~menu.positionLeft : isRight()
                      ? ~menu.positionRight : ~0
    }

    width: Theme.iconSizeSmall
    height: Theme.iconSizeSmall
    opacity: 0

    Canvas {
        id: canvas

        onPaint: {
            var ctx = getContext("2d")
            ctx.reset()
            // temp design of center handle
            if (isCenter()) {
                ctx.translate(canvas.width / 2, canvas.height / 2)
                ctx.rotate(Math.PI / 4)
                ctx.scale(0.85, 0.85)
                ctx.translate(-canvas.width * 0.38, -canvas.height / 2)
            }
            ctx.fillStyle = color
            ctx.beginPath()

            ctx.moveTo((isLeft() ? bigRadius : smallRadius), 0)
            ctx.lineTo(width - (isLeft() ? smallRadius : bigRadius), 0)
            ctx.arcTo(width, 0, width, (isLeft() ? smallRadius : bigRadius), (isLeft() ? smallRadius : bigRadius))

            ctx.lineTo(width, height - bigRadius)
            ctx.arcTo(width, height, width - bigRadius, height, bigRadius)

            ctx.lineTo(bigRadius, height)
            ctx.arcTo(0, height, 0, height - bigRadius, bigRadius)

            ctx.lineTo(0, (isLeft() ? bigRadius : smallRadius))
            ctx.arcTo(0, 0, (isLeft() ? bigRadius : smallRadius), 0, (isLeft() ? bigRadius : smallRadius))

            ctx.closePath()
            ctx.fill()
        }

        anchors.fill: parent
    }
}
