/**
 * SPDX-FileCopyrightText: 2024-2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#ifndef SAILFISH_MDM_RUNTIMEMANAGER_P_H
#define SAILFISH_MDM_RUNTIMEMANAGER_P_H

#include "mdm-runtimemanager.h"
#include "base-mdm-proxy-interface_p.h"

namespace Sailfish {
namespace Mdm {

class RuntimeManagerPrivate : public BaseMdmProxyInterface
{
    Q_OBJECT

public:
    RuntimeManagerPrivate(RuntimeManager *parent);
    ~RuntimeManagerPrivate();

    void customInitProxyPrep() override;

    QString lastErrorName;
    QString lastErrorMessage;
    RuntimeManager *q_ptr;
};

QDBusArgument &operator<<(QDBusArgument &arg, const RuntimeManager::StartReason &reason);
const QDBusArgument &operator>>(const QDBusArgument &arg, RuntimeManager::StartReason &reason);
QDBusArgument &operator<<(QDBusArgument &arg, const RuntimeManager::ApplicationState &state);
const QDBusArgument &operator>>(const QDBusArgument &arg, RuntimeManager::ApplicationState &state);
QDBusArgument &operator<<(QDBusArgument &arg, const RuntimeManager::RunningApplication &app);
const QDBusArgument &operator>>(const QDBusArgument &arg, RuntimeManager::RunningApplication &app);
QDBusArgument &operator<<(QDBusArgument &arg, const RuntimeManager::RunningService &srv);
const QDBusArgument &operator>>(const QDBusArgument &arg, RuntimeManager::RunningService &srv);

} // namespace Mdm
} // namespace Sailfish

Q_DECLARE_METATYPE(Sailfish::Mdm::RuntimeManager::RunningApplication);
Q_DECLARE_METATYPE(Sailfish::Mdm::RuntimeManager::RunningService);

#endif // SAILFISH_MDM_RUNTIMEMANAGER_H
