/**
 * SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#include <QObject>
#include <QDBusInterface>

namespace Sailfish {
namespace Mdm {

class Settings;

class SettingsPrivate : QObject
{
    Q_OBJECT
    Q_DISABLE_COPY(SettingsPrivate)
    Q_DECLARE_PUBLIC(Settings)
public:
    SettingsPrivate(Settings *parent);
    ~SettingsPrivate() = default;

    mutable QDBusInterface m_iface;
    Settings *q_ptr;
};

} // namespace Mdm
} // namespace Sailfish
