/**
 * SPDX-FileCopyrightText: 2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#pragma once

#include <QObject>
#include <QScopedPointer>

#include "contact.h"

namespace Aurora {
namespace Contacts {

class ContactsManagerPrivate;

class Q_DECL_EXPORT ContactsManager : public QObject
{
    Q_OBJECT
    Q_ENUMS(ErrorCode)
public:
    enum ErrorCode
    {
        NO_ERROR = 0,
        CONTACT_DOESNT_EXIST,
        CONNECTION_ERROR,
        QUERY_ERROR,
        OTHER
    };

    explicit ContactsManager(QObject *parent = nullptr);
    virtual ~ContactsManager();

    void queryAllContacts();
    void queryContact(int id);
    void queryContactsDbVersion();

Q_SIGNALS:
    void contactsAdded(QList<Contact> &contacts);
    void contactsRemoved(QList<Contact> &contacts);
    void contactsChanged(QList<Contact> &contacts);
    void contactsDbVersionChanged(uint version);

    void allContactsAvailable(QList<Contact> &contacts);
    void contactAvailable(Contact &contact);
    void error(ErrorCode errorCode);

private:
    Q_DISABLE_COPY(ContactsManager)
    Q_DECLARE_PRIVATE(ContactsManager)
    QScopedPointer<ContactsManagerPrivate> d;
};

}
}
