/****************************************************************************
**
** SPDX-FileCopyrightText: 2022-2025 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: BSD-3-Clause
**
****************************************************************************/

import QtQuick 2.6
import Sailfish.Silica 1.0
import Sailfish.Silica.private 1.0

SequenceFilterPrivate {
    id: blur

    property bool isLightScheme: Theme.colorScheme === Theme.DarkOnLight
    property real overlayColorOpacity: 0.94

    ResizeFilterPrivate {
        size {
            width: 48
            height: 48
        }
        fillMode: FillPrivate.PreserveAspectFit
    }

    ShaderFilterPrivate {
        readonly property color overlayColor: Theme.rgba(blur.isLightScheme ? "white" : "black",
                                                         blur.overlayColorOpacity)

        enabled: blur.overlayColorOpacity > 0.0

        fragmentShader: "
            uniform lowp sampler2D sourceTexture;
            uniform lowp vec4 overlayColor;

            varying highp vec2 sourceCoord;

            void main() {
                gl_FragColor = overlayColor + texture2D(sourceTexture, sourceCoord) * (1.0 - overlayColor.a);
            }
        "
    }

    ConvolutionFilterPrivate {
        id: convolutionFilter

        kernel: KernelPrivate.gaussian(KernelPrivate.SampleSize17, 5)
    }
}
