/*
 * Copyright (c) 2017 - 2020 Jolla Ltd.
 *
 * License: Proprietary
 */

#ifndef SAILFISH_MDM_ACCOUNTS_SERIALISATION_IMPL_P_H
#define SAILFISH_MDM_ACCOUNTS_SERIALISATION_IMPL_P_H

#include <QDBusArgument>
#include <QDBusMetaType>
#include <QtDebug>

#include "mdm-serialisation_impl_p.h"

#ifdef SAILFISH_MDM_PROXY_BUILD
    #define AccountInfoDataType Sailfish::Mdm::Proxy::Accounts::Provisioner::AccountInfo
#else
    #define AccountInfoDataType Sailfish::Mdm::Accounts::Provisioner::AccountInfo
#endif

QDBusArgument &operator<<(QDBusArgument &argument, const AccountInfoDataType &data)
{
    argument.beginStructure();
    argument << data.accountId;
    argument << data.providerName;
    argument << data.remoteIdentifier;
    argument.endStructure();
    return argument;
}

const QDBusArgument &operator>>(const QDBusArgument &argument, AccountInfoDataType &data)
{
    argument.beginStructure();
    argument >> data.accountId;
    argument >> data.providerName;
    argument >> data.remoteIdentifier;
    argument.endStructure();
    return argument;
}

#endif // SAILFISH_MDM_ACCOUNTS_SERIALISATION_IMPL_P_H
