/*
 * Copyright (c) 2020 Open Mobile Platform LLС.
 *
 * License: Proprietary
 */

#ifndef MDM_CALLSHISTORY_SERIALISATION_IMPL_P_H
#define MDM_CALLSHISTORY_SERIALISATION_IMPL_P_H

#include <QDBusArgument>
#include <QDBusMetaType>
#include <QtDebug>

#include "mdm-serialisation_impl_p.h"

#ifdef SAILFISH_MDM_PROXY_BUILD
    typedef CallHistoryProxy::HistoryData CallHistoryResultType;
#else
    typedef Sailfish::Mdm::CallHistoryPrivate::HistoryData CallHistoryResultType;
#endif

QDBusArgument &operator<<(QDBusArgument &argument, const CallHistoryResultType &data)
{
    argument.beginStructure();
    argument << data.secondsSinceEpoch;
    argument << data.secondsAfterCall;
    argument << data.phoneNumber;
    argument.endStructure();
    return argument;
}

const QDBusArgument &operator>>(const QDBusArgument &argument, CallHistoryResultType &data)
{
    argument.beginStructure();
    argument >> data.secondsSinceEpoch;
    argument >> data.secondsAfterCall;
    argument >> data.phoneNumber;
    argument.endStructure();
    return argument;
}

#endif
